function [data] = process_T_log(data_dir)

if data_dir(end)~='\'
    data_dir = [data_dir '\'];
end
f = dir([data_dir '*Temperature_Log.txt']);
g = struct2cell(f);
filelist = g(1,:)';
n = length(filelist);


LV_time = [];
data.T_plate = [];
data.T_air = [];
for i = 1:length(n)
    filename = filelist{i};
    fid = fopen(filename);
    line = fgetl(fid);

    delims = length(regexpi(line,'\t'));
    data_mat = fscanf(fid,'%f',[delims+1 inf]);
    data_mat = data_mat';

    LV_time = [LV_time; data_mat(:,1)];
    data.Heater =  [data.T_plate; data_mat(:,2)];
    data.T_plate = [data.T_plate; data_mat(:,3)];
    data.T_air = [data.T_air data_mat(:,4)];
    
end

data.time = datetime(LV_time,'ConvertFrom','epochTime','Epoch','1904-01-01','TimeZone','UTC');

end